#macro TiltFighter(Loc,Rot,ERot,Inside,TEX)
/*#if (Rot.z > 90)
#declare RotZ = 90;  
#else              
#declare RotZ = Rot.z;
#end 
 
#if (Rot.x > 90)
#declare RotX = 90;
#else              
#declare RotX = Rot.x;
#end*/
#declare RotZ = Rot.z
#declare RotX = Rot.x
  

#declare EngRot1 = ((RotZ)/2)+((-RotX)/2)+ERot
#declare EngRot2 = ((-RotZ)/2)+((-RotX)/2)+ERot


declare Scarring =
texture {pigment {bozo color_map {[0 rgb 0 transmit .875][1 rgb 0 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb 0 transmit .667][1 rgb 0 transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare ScarBank =
texture {Scarring}
texture {Scarring scale 2}
texture {Scarring scale 4}

#if (TEX = 1)
#declare TopTex1 =
texture {
pigment {
image_map {
png "c:\top.png"  
interpolate 2
}
} 
finish {ambient .125/2 diffuse 1.375 phong .125 metallic phong_size 40} 
scale <46,63.25,1> 
rotate 90*x
translate <-23,0,-35.5>     
}
texture {ScarBank}

#declare SideTex1 =
texture {
pigment {
image_map {
png "c:\side1.png"  
interpolate 2
}
} 
finish {ambient .125/2 diffuse 1.375 phong .125 metallic phong_size 40} 
scale <51.2,45,1>
rotate -90*y
translate < 0, -22.5, -51 >
}
texture {ScarBank}

#declare SideTex2 =
texture {
pigment {
image_map {
png "c:\side2.png"  
interpolate 2
}
} 
finish {ambient .125/2 diffuse 1.375 phong .125 metallic phong_size 40} 
scale <51.2,45,1>
rotate -90*y
translate < 0, -22.5, -51 >
}
texture {ScarBank}
#end  


#if (TEX = 2)
#declare TopTex1 =
texture {
pigment {
image_map {
png "c:\topa.png"  
interpolate 2
}
} 
finish {ambient .125/2 diffuse 1.375 phong .125 metallic phong_size 40} 
scale <46,63.25,1> 
rotate 90*x
translate <-23,0,-35.5>     
}
texture {ScarBank}

#declare SideTex1 =
texture {
pigment {
image_map {
png "c:\side1a.png"  
interpolate 2
}
} 
finish {ambient .125/2 diffuse 1.375 phong .125 metallic phong_size 40} 
scale <51.2,45,1>
rotate -90*y
translate < 0, -22.5, -51 >
}
texture {ScarBank}

#declare SideTex2 =
texture {
pigment {
image_map {
png "c:\side2a.png"  
interpolate 2
}
} 
finish {ambient .125/2 diffuse 1.375 phong .125 metallic phong_size 40} 
scale <51.2,45,1>
rotate -90*y
translate < 0, -22.5, -51 >
}
texture {ScarBank}
#end


#if (Inside = false)
#declare RBox =
superellipsoid {
<.125, .125>
translate <1,1,1>
scale .5
}                
#declare RBox2 =
superellipsoid {
<.25, .25>
translate <1,1,1>
scale .5
}               
#declare RBox2a =
superellipsoid {
<.2, .2>
translate <1,1,1>
scale .5
}               
#declare RBox3 = superellipsoid {
<.5, .5>
translate <1,1,1>
scale .5
}
#else
#declare RBox = box{0,1}
#declare RBox2 = box{0,1}
#declare RBox2a = box{0,1}
#declare RBox3 = box{0,1}
#end


#macro Cannon2CM(Fire,FireRepeat) 
#if (clock > Fire)
#declare Clock = mod((clock - Fire)*(FireRepeat)/((1+Fire) - Fire), 1);
#else
#declare Clock = 0
#end

#if (clock > Fire)
#declare RClock = mod((clock - Fire)*(FireRepeat*3)/((1+Fire) - Fire), 1);
#else
#declare RClock = 0
#end

 
#declare mclock = (RClock<0.5?pow(RClock*2,.25/.5):pow(1-(RClock*2-1),4*.5));

#declare C_Tex =
texture {
pigment {
gradient z
color_map {
[0 color rgb .35]
[.475 color rgb .35]
[.525 color rgb (<1,1,0>+.5)/2]
[1 color rgb (<1,1,0>+.5)/2]
}
}
finish {
ambient 0
diffuse 1
phong .25
metallic
}
rotate 45*x
scale 2
}
texture {ScarBank} 

#declare B_Tex =
texture {
pigment { rgb .25
}
finish {
ambient 0
diffuse 1
phong .25
metallic
}
}
texture {ScarBank}   

#declare B_Tex2 =
texture {
pigment { rgb .125
}
finish {
ambient 0
diffuse 1
phong .25
metallic
}
}
texture {ScarBank}  

#declare A_Tex =
texture {
pigment { rgb .66}
finish {
ambient 0
diffuse 1
phong .25
metallic
}
}
texture {ScarBank}

// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: Main Sheath
      object
      {
         union
         {
            // Object type: Cylinder
            // Name: Base
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

               scale < 1.5, 4, 1.5 >

               texture
               {
                  B_Tex
                  scale < 1.5, 4, 1.5 >
               }
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Polynomial
                  // Name: Body
                  object
                  {
                     RBox2

                     scale < 4, 7.5, 11.75 >
                     translate < -2, 1, -6.25 >
                  }
                  // Object type: Polynomial
                  // Name: Body
                  object
                  {
                     RBox2

                     scale < 6, 4.75, 8 >
                     translate < -3, 0, -10.25 >
                  }
                  // Object type: Polynomial
                  // Name: Body
                  object
                  {
                     RBox2

                     scale < 3.5, 7.5, 11.75 >
                     translate < -1.75, 0.5, -13.5 >
                  }
               }
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 4.5, 2.25, 8 >
               translate < -2.25, 5.75, -3 >
            }
         }
      }
      // Object type: Composite
      // Name: Recoiler
      object
      {
         union
         {
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -4.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -2.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -2.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -3.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -3.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -4.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -6.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -6.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -5.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -5.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -7.25 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -7.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox3

               scale < 3, 7, 0.5 >
               translate < -1.5, 0.75, -8.25 >
            }
         }

         texture
         {
            B_Tex
         }
     translate 2*z
     scale <1,1,-.5*mclock+1>    
     translate -2*z
      }
      // Object type: Composite
      // Name: Barrels & Nozzels
      object
      {
         union
         {
            
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               translate < -1, 7.75, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               translate < 0.75, 7.75, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               translate < -1, 0.25, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               translate < 0.75, 0.25, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               rotate < 0, 0, 90 >
               translate < 1.5, 5, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               rotate < 0, 0, 90 >
               translate < 1.5, 3.25, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               rotate < 0, 0, 90 >
               translate < -1.25, 5, -15.75 >
            }
            // Object type: Polynomial
            // Name: Body
            object
            {
               RBox2

               scale < 0.25, 0.5, 1.5 >
               rotate < 0, 0, 90 >
               translate < -1.25, 3.25, -15.75 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               rotate < -90, 0, 0 >
               translate < 0, 2.25, -16 >
               texture {B_Tex2}
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               rotate < -90, 0, 0 >
               translate < 0, 6.25, -16 >
               texture {B_Tex2}
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75 open }

               rotate < -90, 0, 0 >
               translate < 0, 4.25, -16 >
               texture {B_Tex2}
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

               scale < 1, 6.5, 1 >
               rotate < 90, 0, 0 >
               translate < 0, 2.25, -14.5 >

               texture
                     {
                        C_Tex
                        scale .5
                        rotate 45*z
                     }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

               scale < 1, 6.5, 1 >
               rotate < 90, 0, 0 >
               translate < 0, 4.25, -14.5 >

               texture{B_Tex2}
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

               scale < 1, 6.5, 1 >
               rotate < 90, 0, 0 >
               translate < 0, 6.25, -14.5 >

               texture
                     {
                        C_Tex
                        scale .5
                        rotate 45*z
                     }
            }
            // Object type: Difference
            // Name: Nozzels
            object
            {
               difference
               {
                  // Object type: Polynomial
                  // Name: Body
                  object
                  {
                     RBox2

                     scale < 2.5, 7.5, 2 >
                     translate < -1.25, 0.5, -16 >

                     texture
                     {
                        B_Tex
                        scale .5
                        rotate 45*z
                     }
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 1, 2.875, 1 >
                     rotate < 90, 0, 0 >
                     translate < 0, 6.25, -16.375 >
                     
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 1, 2.875, 1 >
                     rotate < 90, 0, 0 >
                     translate < 0, 4.25, -16.375 >
                     
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 1, 2.875, 1 >
                     rotate < 90, 0, 0 >
                     translate < 0, 2.25, -16.375 >
                     
                  }
               }

               texture
               {
                  B_Tex
                  translate < 0, 4.25, -15 >
               }
            }
            
         }

         texture
         {
            B_Tex
         }
         translate <0,0,4*mclock>
      }
// Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 1, 5, 1 >
         rotate < 90, 0, 0 >
         translate < 2, 4, -0.75 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         translate < 2, 4, 4.25 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 1, 1, 0.75 >
         translate < 2, 4, -0.75 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 3 >
         translate < -1.5, 8.25, -5.875 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 3 >
         translate < -1.5, 8.25, 2.25 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 1 >
         translate < -1.5, 8.25, -2.375 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 1 >
         translate < -1.5, 8.25, -0.875 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 0.5, 1 >
         translate < -1.5, 8.25, 0.625 >
      }


#declare BR = 1-(3*RClock)

 
#declare MFlash =
union {
sphere {0, 1 hollow on
pigment {Clear}
interior {
media{
emission .5*BR
density { spherical
color_map{
[0.0 rgb <1,.25,0>*0]
[.5 rgb <1,.75,0>*.25]
[1.0 rgb <1,1,1>]
}
}
}
}
scale <10,1,1>
rotate <0,0,1500*Clock>
translate < 0, 0, -17.5 >
translate <0,0,mclock*2>
}

sphere {0, 1 hollow on
pigment {Clear}
interior {
media{
emission .5*BR
density { spherical
color_map{
[0.0 rgb <.125,.125,1>*0]
[.5 rgb <.5,.5,1>*.25]
[1.0 rgb <1,1,1>]
}
}
}
}
scale <1,15,1>
rotate <0,0,-1000*Clock>
translate < 0, 0, -17.5 >
translate <0,0,mclock*2>
} 

sphere {0, 1 hollow on
pigment {Clear}
interior {
media{
emission 1*BR
density { spherical
color_map{
[0.0 rgb <.25,.25,1>*0]
[.5 rgb <.75,.75,1>*.25]
[1.0 rgb <1,1,1>]
}
translate 4*RClock*z
warp {turbulence RClock*4 }
translate -4*RClock*z
}
}
}
rotate <0,0,-1000*Clock>
scale <1.5,1.5,12>
translate < 0, 0, -17 >
translate <0,0,mclock*4>
}
sphere {0, 1 hollow on
pigment {Clear}
interior {
media{
emission 1*BR
density { spherical
color_map{
[0.0 rgb <.25,.25,1>*0]
[.5 rgb <.75,.75,1>*.25]
[1.0 rgb <1,1,1>]
}
translate 4*RClock*z
warp {turbulence RClock*4 }
translate -4*RClock*z
}
}
} 
rotate <0,0,-1000*Clock>
scale 3
translate < 0, 0, -17.5 >
translate <0,0,mclock*4>
}
}
#while (Clock > Fire)
#switch (Clock)
#range (0,.125)
union {MFlash translate 6.25*y}
#break
#range (.33,(.33+(.125)))
union {MFlash translate 4.25*y}
#break
#range (.66,(.66+(.125)))
union {MFlash translate 2.25*y}
#break
#else
#end  
#end

/*union {MFlash translate 6.25*y}  
union {MFlash translate 4.25*y}
union {MFlash translate 2.25*y}*/
}
texture {A_Tex}
scale 1
rotate -90*z
}
#end

#declare Fusalage =
object
{
   union
   {
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.6  }

                     scale < 10, 12, 35 >
                     rotate < 0, 0, 90 >
                     translate < -6, 0, 0 >
                  }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.55  }

                     scale < 9, 13, 33 >
                     rotate < 0, 0, 90 >
                     translate < -6, -2.0433e-21, 0 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 0.75, 10, 0.75 >
                     translate < -8, 0, -16 >
                  }
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 14, 11, 37 >
               translate < -20, 0, -37 >
            }
         }
      }
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.6  }

                     scale < 10, 12, 35 >
                     rotate < 0, 0, -90 >
                     translate < 6, -3.7352e-22, 1.4694e-39 >
                  }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.55  }

                     scale < 9, 13, 33 >
                     rotate < 0, 0, -90 >
                     translate < 6, 1.635e-24, 0 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 0.75, 10, 0.75 >
                     translate < 8, 0, -16 >
                  }
               }
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 14, 11, 37 >
               translate < 6, 0, -37 >
            }
         }
      } 
      difference {
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 10, 12, 35 >
               rotate < 0, 0, -90 >
               translate < -6, -2.647e-23, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 12, 11, 50 >
               translate < -6, 0, -38 >
            }
         }
      } 
       // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 8, 10.5, 19 >
         translate < -4, 1, -32 >  
         
         texture {pigment {rgb .125}}
         texture {ScarBank}
      }
      }
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 4.5, 12, 35 >
               rotate < 0, 0, 90 >
               translate < 6, -5.2454e-07, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 12, 4.95, 50 >
               rotate < 0, 0, 180 >
               translate < 6, -5.2454e-07, -38 >
            }
         }
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2a

         scale < 14, 14, 27 >
         translate < -7, -4, 0 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.8  }

               scale < 6, 9, 25 >
               rotate < 0, 0, 90 >
               translate < -6, 2, 7.8886e-31 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < 90, 0, 0 >
               translate < -6, 0, 0 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.75, 10, 0.75 >
               translate < -10, 0, 1.5 >
            }
         }
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.8  }

               scale < -6, -9, -25 >
               rotate < 180, 0, -90 >
               translate < 6, 2, 0 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < -20, -1, -20 >
               rotate < -90, 0, 0 >
               translate < 6, 0, 0 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.75, 10, 0.75 >
               translate < 10, 0, 1.5 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 5, 34, 5 >
         rotate < 0, 0, -90 >
         translate < -17, 2, 14 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 1 }

         rotate < 0, 0, -90 >
         translate < -17, 2, 14 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 1 }

         rotate < 0, 0, -90 >
         translate < 17, 2, 14 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.8  }

         scale < 4, 2, 4 >
         rotate < 0, 0, -90 >
         translate < 18, 2, 14 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.8  }

         scale < 4, 2, 4 >
         rotate < 0, 0, 90 >
         translate < -18, 2, 14 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 3, 1, 3 >
         rotate < 0, 0, -90 >
         translate < 20, 2, 14 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 3, 1, 3 >
         rotate < 0, 0, -90 >
         translate < -21, 2, 14 >
      }
            // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 10, 0.5 }

               scale < -0.57143, -1.5, -1.9762 >
               rotate < 0, 0, -90 >
               translate < 18, 5.9605e-08, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 4.125, 7.5, 21 >
               translate < 16.125, 5.9605e-08, -21 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

         scale < 0.75, 18.629, 0.5 >
         rotate < 90, -39.778, -2.2589e-06 >
         translate < -6, 5.8586e-22, -34 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 0.75, 0.75, 0.75 >
         translate < -6, 0, -34 >
      }
      union {
            // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 10, 0.5 }

               scale < -0.57143, -1.5, -1.9762 >
               rotate < 0, 0, -90 >
               translate < 18, 5.9605e-08, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 4.125, 7.5, 21 >
               translate < 16.125, 5.9605e-08, -21 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

         scale < 0.75, 18.629, 0.5 >
         rotate < 90, -39.778, -2.2589e-06 >
         translate < -6, 5.8586e-22, -34 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 0.75, 0.75, 0.75 >
         translate < -6, 0, -34 >
      }
      scale <-1,1,1>
      }

sphere_sweep{
linear_sphere_sweep,
7,
<-10,0,1.5>,.5 
<-10,9,1.5>,.5
<-10,8.75,-5.5>,.5
<-10,8.5,-11.75>,.5
<-10,8,-16>,.5 
<-8,8.5,-16>,.5
<-8,0,-16>,.5
pigment {rgb .25}
} 
sphere_sweep{
linear_sphere_sweep,
7,
<10,0,1.5>,.5 
<10,9,1.5>,.5
<10,8.75,-5.5>,.5
<10,8.5,-11.75>,.5
<10,8,-16>,.5 
<8,8.5,-16>,.5
<8,0,-16>,.5
pigment {rgb .25}
}
// Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 8, 4, 6 >
         rotate < 6.6592, 0, 0 >
         translate < -4, 7.5, -15.5 >
      }
      union {
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 10, 0.5 }

               scale < -0.57143, -1.5, -1.9762 >
               rotate < 0, 0, -90 >
               translate < 18, 5.9605e-08, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 4.125, 7.5, 21 >
               translate < 16.125, 5.9605e-08, -21 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

         scale < 0.75, 18.629, 0.5 >
         rotate < 90, -39.778, -2.2589e-06 >
         translate < -6, 5.8586e-22, -34 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 0.75, 0.75, 0.75 >
         translate < -6, 0, -34 >
      }
      
      }
      union {
      // Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 10, 0.5 }

               scale < -0.57143, -1.5, -1.9762 >
               rotate < 0, 0, -90 >
               translate < 18, 5.9605e-08, 0 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 4.125, 7.5, 21 >
               translate < 16.125, 5.9605e-08, -21 >
            }
         }
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1}

         scale < 0.75, 18.629, 0.5 >
         rotate < 90, -39.778, -2.2589e-06 >
         translate < -6, 5.8586e-22, -34 >
      }
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 0.75, 0.75, 0.75 >
         translate < -6, 0, -34 >
      }
      scale <-1,1,1>
      }
       
 
   }
   texture{TopTex1}
} 
#if (Inside = false)
#declare TestEngine =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 6, 38, 47 >
                     translate < -6, -19, -50 >
                  }
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 5, 16.364, 50 >
                           translate < -2.6645e-15, -8.1818, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 5, 9.8182, 50 >
                           translate < -2.6645e-15, 8.1818, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 5, 9.8182, 50 >
                           translate < -2.6645e-15, -8.1818, 0 >
                        }
                     }
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 36, 1 >
               translate < 0, -18, -29 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 40, 1 >
               translate < 0, -20, -9 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 28, 1 >
               translate < 0, -14, -44 >
            }
         }              
       texture {SideTex2}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, -10, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, 6, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, 1, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, -5, -5 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 12, 20, 50 >
                           translate < 0, -10, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 12, 12, 50 >
                           translate < 0, 10, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 12, 12, 50 >
                           translate < 0, -10, 0 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 13, 46, 50 >
                     translate < 0, -23, -50 >
                  }
               }
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 6, 18, 53 >
               translate < 1, -9, -51 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 9, 18, 17 >
               translate < 1, -9, -51 >
            }
         }
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -8.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 8, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -5.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 3.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -2.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 6.5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -4, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 5, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -7, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 2, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, -1, -33 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 8, 0.5, 29 >
         translate < 0, 0.5, -33 >
      }
            // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

               scale < 7, 3, 7 >
               rotate < 0, 0, 90 >
               translate < -3.5, 0, -24.5 >        
               texture {pigment {rgb .25}}
               texture {ScarBank}
               
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 4.5, 15.5, 14 >
                     translate < -7.5, -7.5, -24.5 >
                  }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

                     scale < 7, 3, 2000 >
                     rotate < 0, 0, 90 >
                     translate < -3.5, 0, -17.5 >
                  }
               }
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

               scale < 7, 3, 7 >
               rotate < 0, 0, 90 >
               translate < -3.5, 0, -10.5 >
            }
         }
         scale <1,2,1> 
         texture {SideTex2}
      }
      // Object type: HeightField
      // Name: NOZZLE~1.TGA
      object
      {
         height_field { tga "C:\NOZZLE~1.TGA" smooth water_level .01 translate -.01*y }

         scale < -13.5, -24, -40 >
         rotate < -90, 0, 0 >
         translate < 12.5, 20, 0 >
         texture {pigment {image_map {png "c:\nozzletex.png" interpolate 2}}
         finish {ambient .25/4 diffuse 1}
         scale <13.5,40,1>
         translate < -1, 20, 0 >
         } 
         texture {pigment { gradient z triangle_wave
         color_map {
         [.5 rgbt <0,0,0,1>]
         [.6 rgb .25 transmit .5]
         }
         }
         scale 2
         }  
         texture {pigment {image_map {png "c:\nozzleglow.png" interpolate 2}} finish {ambient 4 phong .125}
         scale <13.5,40,1>
         translate < -1, 20, 0 >
         } 
         texture {pigment {image_map {png "c:\nozzleglow.png" interpolate 2}} finish {ambient 1 phong .25}
         scale <13.5,40,1>
         translate < -1, 20, 0 > 
         scale 1.25*y
         }

      }
/*
object {               
box { < 0, 0, 0 >, < 1, 1, 1 > }
hollow on no_shadow
scale < 22, 6, 30 >
translate < -11, -3, 0 > 
pigment {rgbt 1}         
interior {
media{
intervals 5
samples 1,5
variance 1/100
confidence .9
emission <.375,.25,.75>*.5
density { spherical
color_map{
[0 rgb 0] 
[.66 rgb .25]
[1 rgb .5]
}
scale <100,8,30>
translate <0,0,0>
} 
density { spherical
color_map{
[0 rgb 0]
[.25 rgb 1]
[1.0 rgb 1]
}
scale <13,50,100>
translate <0,0,0>
}
density { bozo
color_map{
[0 rgb 1]
[1.0 rgb .5]
}
translate -40*clock*z 
warp {turbulence 1}
translate 40*clock*z
scale <2,2,4>
}
density { bozo
color_map{
[0 rgb 1.5]
[1.0 rgb .5]
}
translate -20*clock*z
warp {turbulence 4}
translate 20*clock*z 
scale <2,2,4>*2
}  
density { bozo
color_map{
[0 rgb 2]
[1.0 rgb .5]
}
translate -10*clock*z
warp {turbulence 1}
translate 10*clock*z 
scale 6
}
}
}
rotate -90*z
translate <5.5,0,3>
} */
      
      
sphere_sweep{
linear_sphere_sweep,
7, 
< -.5, 0, -9 >,.5
< -.5, -20, -9 >,.5
< -.5, -18, -29 >,.5 
< -.5, 0, -29 >,.5  
< -.5, -18, -29 >,.5
< -.5, -14, -44 >,.5
< -.5, 0, -44 >,.5
pigment {rgb .2}
}
sphere_sweep{
linear_sphere_sweep,
7,
< -.5, 0, -9 >,.5
< -.5, 20, -9 >,.5
< -.5, 18, -29 >,.5 
< -.5, 0, -29 >,.5  
< -.5, 18, -29 >,.5
< -.5, 14, -44 >,.5
< -.5, 0, -44 >,.5
pigment {rgb .2}
}
}
texture {SideTex1} 
translate 24*z  
scale <1,.75,1>
}
#declare TestEngine2 =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 6, 38, 47 >
                     translate < -6, -19, -50 >
                  }
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 5, 16.364, 50 >
                           translate < -2.6645e-15, -8.1818, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 5, 9.8182, 50 >
                           translate < -2.6645e-15, 8.1818, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 5, 9.8182, 50 >
                           translate < -2.6645e-15, -8.1818, 0 >
                        }
                     }
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 36, 1 >
               translate < 0, -18, -29 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 40, 1 >
               translate < 0, -20, -9 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1.5, 28, 1 >
               translate < 0, -14, -44 >
            }
         }              
       texture {SideTex2}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, -10, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, 6, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, 1, -5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 9, 4, 4 >
         translate < -5, -5, -5 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 12, 20, 50 >
                           translate < 0, -10, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 12, 12, 50 >
                           translate < 0, 10, 0 >
                        }
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 12, 12, 50 >
                           translate < 0, -10, 0 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 13, 46, 50 >
                     translate < 0, -23, -50 >
                  }
               }
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 6, 18, 53 >
               translate < 1, -9, -51 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 9, 18, 17 >
               translate < 1, -9, -51 >
            }
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

               scale < 7, 3, 7 >
               rotate < 0, 0, 90 >
               translate < -3.5, 0, -24.5 >        
               texture {pigment {rgb .25}}
               texture {ScarBank}
               
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 4.5, 15.5, 14 >
                     translate < -7.5, -7.5, -24.5 >
                  }
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

                     scale < 7, 3, 2000 >
                     rotate < 0, 0, 90 >
                     translate < -3.5, 0, -17.5 >
                  }
               }
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

               scale < 7, 3, 7 >
               rotate < 0, 0, 90 >
               translate < -3.5, 0, -10.5 >
            }
         }
         scale <1,2,1> 
         texture {SideTex2}
      }
      // Object type: HeightField
      // Name: NOZZLE~1.TGA
      object
      {
         height_field { tga "C:\NOZZLE~1.TGA" smooth water_level .01 translate -.01*y }

         scale < -13.5, -24, -40 >
         rotate < -90, 0, 0 >
         translate < 12.5, 20, 2.8541e-21 >
         texture {pigment {image_map {png "c:\nozzletex.png" interpolate 2}}
         finish {ambient .25/4 diffuse 1}
         scale <13.5,40,1>
         translate < -1, 20, 0 >
         } 
         texture {pigment { gradient z triangle_wave
         color_map {
         [.5 rgbt <0,0,0,1>]
         [.6 rgb .25 transmit .5]
         }
         }
         scale 2
         }  
         texture {pigment {image_map {png "c:\nozzleglow.png" interpolate 2}} finish {ambient 4 phong .125}
         scale <13.5,40,1>
         translate < -1, 20, 0 >
         } 
         texture {pigment {image_map {png "c:\nozzleglow.png" interpolate 2}} finish {ambient 1 phong .25}
         scale <13.5,40,1>
         translate < -1, 20, 0 > 
         scale 1.25*y
         } 
         
}
/*object
{
box { < 0, 0, 0 >, < 1, 1, 1 > }
hollow on no_shadow
scale < 22, 6, 30 >
translate < -11, -3, 0 > 
pigment {rgbt 1}         
interior {
media{
intervals 5
samples 1,5
variance 1/100
confidence .9
emission <.375,.25,.75>*.5
density { spherical
color_map{
[0 rgb 0] 
[.66 rgb .25]
[1 rgb .5]
}
scale <100,8,30>
translate <0,0,0>
} 
density { spherical
color_map{
[0 rgb 0]
[.25 rgb 1]
[1.0 rgb 1]
}
scale <13,50,100>
translate <0,0,0>
}
density { bozo
color_map{
[0 rgb 1]
[1.0 rgb .5]
}
translate -40*clock*z 
warp {turbulence 1}
translate 40*clock*z
scale <2,2,4>
}
density { bozo
color_map{
[0 rgb 1.5]
[1.0 rgb .5]
}
translate -20*clock*z
warp {turbulence 4}
translate 20*clock*z 
scale <2,2,4>*2
}  
density { bozo
color_map{
[0 rgb 2]
[1.0 rgb .5]
}
translate -10*clock*z
warp {turbulence 1}
translate 10*clock*z 
scale 6
}
}
}
rotate -90*z
translate <5.5,0,3>
}*/

}
texture {SideTex1} 
}  
#end

#declare CocChair = 
  // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 3.0321, 5.6821, 2.0214 >
               rotate < 4.4771, 10.067, 0.78416 >
               translate < 1.6171, 8.7125, -13.202 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 5.0535, 2.0214, 2.0214 >
               rotate < 11.723, 0, 0 >
               translate < -2.5268, 6.5901, -13.707 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 3.0321, 5.6821, 2.0214 >
               rotate < 4.408, 0, 0 >
               translate < -1.5161, 8.7125, -13.202 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 4.0428, 3.7396, 2.0214 >
               translate < -2.0214, 14.474, -12.798 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 2.5268, 2.0214, 2.0214 >
               rotate < 14.716, 36.887, 8.959 >
               translate < 2.6278, 6.5901, -13.707 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < -3.0321, -5.6821, -2.0214 >
               rotate < -175.52, -10.067, -0.78416 >
               translate < -1.6171, 8.7125, -13.202 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < -2.5268, -2.0214, -2.0214 >
               rotate < -165.28, -36.887, -8.959 >
               translate < -2.6278, 6.5901, -13.707 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 3.6385, 2.0214, 7.3781 >
               rotate < -10.72, 0, 0 >
               translate < -3.8407, 3.3558, -20.479 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 3.6385, 2.0214, 7.3781 >
               rotate < -10.67, 0, 0 >
               translate < 0.20214, 3.3558, -20.479 >
            }
         }
pigment {rgb <.75,.6,.5>}  
}  
#if (Inside = true)
#declare RBox =
superellipsoid {
<.15, .15>
translate <1,1,1>
scale .5
}
#declare PCTex1 =
texture {pigment {rgb .125} finish {ambient .05 phong .25 metallic}}
texture {Scarring}

#macro Display(TotalFrames,Prefix,S,E)  
#if (clock > S)
#if (clock <= E)
#declare keyclock = mod((clock-S)/(E-S),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end


#declare Frame = ceil(((TotalFrames-1)*keyclock)+1);  
texture {
finish {ambient 1 diffuse 1}
pigment {
image_map {
#if (Frame < 100)
#if (Frame < 10)                            
tga concat(Prefix,"00",str(Frame,0,0), ".tga")
#else
tga concat(Prefix,"0",str(Frame,0,0), ".tga")
#end
#else
tga concat(Prefix,str(Frame,0,0), ".tga")
#end
interpolate 2
}
}
} 
#end
   
   
#declare SideScrn=      
height_field { 
tga "c:\screenh2"
smooth 
water_level .1      
translate <-.5,0,-.5>
texture {
pigment {image_map {png "c:\screent2" interpolate 2}}
finish {ambient .125 diffuse 1 phong .125 metallic}
rotate 90*x
translate <-.5,0,-.5> 
}
texture {
pigment {image_map {png "c:\screeng2" interpolate 2}}
finish {ambient 1.5 diffuse .5 phong .5}
rotate 90*x
translate <-.5,0,-.5> 
}
scale<18,1.5,17>
rotate -90*x
} 

#declare CocControls = 
union {
height_field { 
tga "c:\mdsh"
smooth 
water_level .1      
translate <-.5,0,-.5>
texture {
pigment {image_map {png "c:\mdst" interpolate 2}}
finish {ambient .125 diffuse 1 phong .125 metallic}
rotate 90*x
translate <-.5,0,-.5> 
}
texture {
pigment {image_map {png "c:\mdsg" interpolate 2}}
finish {ambient 1.5 diffuse .5 phong .5}
rotate 90*x
translate <-.5,0,-.5> 
}

scale<20,1.5,20> 
rotate -90*x
translate 12*y
}

      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 20, 20, 20 >
         translate < -10, 2, 0 > 
         texture {PCTex1}
      } 
      box {0,1 Display(150,"C:\SDFiles\radar",0,.85) scale <19,19,1> translate <-9.5,.5,-.25>}

      union {
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 18, 17, 20 >
         translate < 10, 0, 0 > 
         texture {PCTex1}
      } 
      box {0,1 Display(150,"C:\SDFiles\1stds",0,.85) scale <17,13.5,1> translate <10.5,.5,-.25>}
      object {SideScrn translate <19,7,0>}   
      translate <19,-7,0> 
      rotate 10*y
      translate <-19,7,6>
      }
      union {
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 18, 17, 20 >
         translate < -28, 0, 0 >
         texture {PCTex1}
      }      
      object {SideScrn translate <-19,7,0>}
      box {0,1 Display(150,"C:\SDFiles\2ndDS",0,.85) scale <17,13.5,1> translate <-27.5,.5,-.25>}
      translate <19,-7,0> 
      rotate -10*y
      translate <-19,7,0>
      }            
      }
      #end
      
#declare Light =
union {
cylinder {0,3*y,1
pigment {Clear}
hollow
interior {
media {
emission <.625,.75,1>/4/15/3 
intervals 15
#declare C=0;
#while (C <360)
density {
cylindrical
color_map {
[0 rgb 0]  
[.125 rgb 1]
}       
rotate 15.5*z     
rotate C*y
}        
#declare C=C+60;
#end
density {
gradient y
color_map {
[0 rgb 0] 
[.125 rgb .125]
[.25 rgb .25]  
[.5 rgb 1.25]
[.825 rgb 35]
[1 rgb 1000]
}       
scale 4
} 
}
} 
translate -3*y 
scale <10,15,10>
translate -1*y
}
sphere {0,.5 pigment {rgb 50}}

sphere {0,1 hollow no_shadow
pigment {rgbt <0,0,0,1>}
interior {
media {
emission <.625,.75,1>/2.5 
//intervals 25
density {
spherical
color_map {
[0 rgb 0]  
[.5 rgb .5]  
[1 rgb 1.5]
}       
}        
}
} 
 
scale 2.5 
}




}




union {
union {Fusalage} 
#if (Inside = false)
union {Cannon2CM(1,1) scale <-1,1,1> translate <15,-2.25,-26>}   
union {Cannon2CM(1,1) scale <1,1,1> translate <-15,-2.25,-26>}

union {TestEngine rotate <EngRot1,0,0>  translate <25,2,14>}
union {TestEngine rotate <EngRot2,0,0>  translate <25,2,14> scale <-1,1,1>} 
//union {TestEngine2 scale <.75,.35,.75> rotate 90*z translate <0,13,32> }   
union {TestEngine2 scale <.75,.35,.75> rotate -80*z translate <8,-4,26>}  
union {TestEngine2 scale <.75,.35,.75> rotate -100*z translate <-8,-4,26>}
#end

#declare CocShield = 
height_field { 
tga "c:\cocp3b"
#if (Inside = false) smooth  #end
water_level .01      
translate <-.5,-.01,-.5>
scale<13,9,25>
texture {
pigment {image_map {png "c:\cocptexa" interpolate 2}
scale <13,25,1>
rotate 90*x
translate <-6.5,0,-12.5> 
scale <1,1,1>
} 
finish {ambient .125/2 diffuse 1.75 phong .125 metallic phong_size 40} 
}
//texture {ScarBank}
#if (Inside = false )
scale <1.1,1,1> 
#else 
scale <1.3,1,1> 
#end
rotate <-20,0,0>
translate <0,5.5,-24.125>
}
#declare InternalCocShield = 
difference {
height_field { 
tga "c:\cocp3a"
#if (Inside = false) smooth  #end
//smooth
translate <-.5,0,-.5> 
scale <1,-1,1>
translate 1*y
scale<13,9,25>
texture {
pigment {image_map {png "c:\cocptex2a" interpolate 2}
scale <13,25,1>
rotate 90*x
translate <-6.5,0,-12.5> 
scale <1,1,1>
} 
finish {ambient .125/2 diffuse 1.75 phong .125 metallic phong_size 40} 
}
}
disc {0,y,40 translate .25*y pigment {rgbt 1} finish {diffuse 0}}
#if (Inside = false )
scale <1.05,1,1> 
#else 
scale <1.35,1,1> 
#end
rotate <-20,0,0>
translate <0,5.5,-24.125>
} 

//union {CocShield}
//union {CocShield translate -.25*y}
union {InternalCocShield translate -.25*y}

  


union {CocChair scale .5 translate <0,1,-13>}
#if (Inside = true) 
union {CocControls rotate 180*y scale .115 translate <0,3.5,-25>}  
#end

//union {Light scale 2 rotate <85,2.5,0> translate <-4,0,-36>}
//union {Light scale 2 rotate <85,-2.5,0> translate <4,0,-36>}
translate <0,0,-16>
rotate Rot
translate Loc
}
/*
#if (Inside = true)

#declare Start = .6;
#declare End = .75; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock = pow(keyclock,.5)
#declare mclock2 = sin((keyclock-.5)*pi)/2+.5 


#declare Start = .75;
#declare End = 1.0001; 
#if (clock > Start)
#if (clock <= End)
#declare keyclock = mod((clock-Start)/(End-Start),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end

#declare mclock3 = sin((keyclock-.5)*pi)/2+.5 


// Object type: Camera
// Name: Tele
camera 
{
   right     < 1, 0, 0   >
   up        < 0, 1, 0   >
   direction < 0, 0, 0.5 >
   location  < 0, 0, 0   >
   scale < 10.853, 8.1401, 8.0592 >
   rotate < -171.3, -4.9783e-06, 180 >
   rotate <20+(50*mclock3),0,0> 
      
   
   #declare S = seed(keyclock)
   #declare R = rand(S)
   rotate (7.5*R)*(mclock2) 
   
   #declare Rclock = sin(clock*2*pi)   
   rotate (-5*Rclock)*z
   
   translate < 0, 9+1.5*mclock3, -22 > 
   translate <0,-3.25,-16>
   rotate Rot
   translate Loc
}   
light_source {  
<0,0,0>
rgb <.4,.4,.5>

translate < 0, 9, -24 > 
   translate <0,-2,-18>
   
   rotate Rot
   translate Loc 
   }

#end*/
#end

